--------------------------------------------------------------------------------
--
-- Behavorial simulation model for Viterbi decoder
--
-- File name    : viterbi.vhd
--
-- Version      :7.0
-- 
--  (c) Copyright 1995-2005, 2009 Xilinx, Inc. All rights reserved.
--
--  This file contains confidential and proprietary information
--  of Xilinx, Inc. and is protected under U.S. and
--  international copyright and other intellectual property
--  laws.
--
--  DISCLAIMER
--  This disclaimer is not a license and does not grant any
--  rights to the materials distributed herewith. Except as
--  otherwise provided in a valid license issued to you by
--  Xilinx, and to the maximum extent permitted by applicable
--  law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
--  WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
--  AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
--  BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
--  INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
--  (2) Xilinx shall not be liable (whether in contract or tort,
--  including negligence, or under any other theory of
--  liability) for any loss or damage of any kind or nature
--  related to, arising under or in connection with these
--  materials, including for any direct, or any indirect,
--  special, incidental, or consequential loss or damage
--  (including loss of data, profits, goodwill, or any type of
--  loss or damage suffered as a result of any action brought
--  by a third party) even if such damage or loss was
--  reasonably foreseeable or Xilinx had been advised of the
--  possibility of the same.
--
--  CRITICAL APPLICATIONS
--  Xilinx products are not designed or intended to be fail-
--  safe, or for use in any application requiring fail-safe
--  performance, such as life-support or safety devices or
--  systems, Class III medical devices, nuclear facilities,
--  applications related to the deployment of airbags, or any
--  other applications that could lead to death, personal
--  injury, or severe property or environmental damage
--  (individually and collectively, "Critical
--  Applications"). Customer assumes the sole risk and
--  liability of any use of Xilinx products in Critical
--  Applications, subject only to applicable laws and
--  regulations governing limitations on product liability.
--
--  THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
--  PART OF THIS FILE AT ALL TIMES. 
--------------------------------------------------------------------------------
--
-- $RCSfile: convolution_unobf_v7_0.vhd,v $

LIBRARY IEEE;USE IEEE.STD_LOGIC_1164.ALL;LIBRARY XILINXCORELIB;USE XILINXCORELIB.BIP_UTILS_PKG_V2_0.ALL;PACKAGE
 CONVOLUTION_PACK_V7_0 IS CONSTANT II1IOOO1II0l1lOl00I1O001I00O0IIIII:STRING(1 TO 1):=(1=>LF);CONSTANT IO1lll0I0l0l1ll1O01Ol0III011IOIIII:INTEGER:=7;CONSTANT
 IOO0111OO0lOOl10l1l000l0OlI0IIIIII:INTEGER:=9;CONSTANT IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII:INTEGER:=16;CONSTANT IOOOlI0llOIl11IO01100OI1llOIIOIIII:INTEGER:=3;CONSTANT
 IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII:INTEGER:=3;CONSTANT II1001IO0010Oll1I01lOI0I0IlIOIIIII:INTEGER:=0;CONSTANT IO110I1O0010OIOlIO00l1IIOl0llIIIII:INTEGER:=3;CONSTANT
 IIIOOIO01011011IOIIlllIIOO0l1IIIII:INTEGER:=4;CONSTANT II1IOOO00I0OI0O01I000O100llOOIIIII:INTEGER:=5;CONSTANT II00OI0110lI1II101lO1OO00I10OIIIII:INTEGER:=7;
CONSTANT II00OIlIlO101I0IIOO0O1I0ll0OIIIIII:INTEGER:=7;CONSTANT IOOI1l1OO01O111lO010OlO1O0l0IIIIII:INTEGER:=7;CONSTANT IO11OllII1lO110Ol0I0O00I01l00IIIII:
INTEGER:=7;CONSTANT III01lO1l00IOOO0O0I0O0I111O0IIIIII:INTEGER:=7;CONSTANT IO1I1l01l1OI111Ol0IO10110I11IOIIII:INTEGER:=7;CONSTANT
 IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII:INTEGER:=0;CONSTANT IIIOI11O0OO00OllOllO00lOI000IOIIII:INTEGER:=0;CONSTANT IIOIOOO11l0lO001OI10I0IIIIlIIIIIII:INTEGER:=0;CONSTANT
 II0IO0I0Olll01OOO0lIOO01lOlIOOIIII:INTEGER:=0;CONSTANT IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:INTEGER:=0;CONSTANT II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII:INTEGER:=0;CONSTANT IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII:INTEGER
:=0;CONSTANT IO0O10O101OOIOOl10lIIO101lIIIIIIII:INTEGER:=1;CONSTANT IIOl10001I1Ol001OIO01IO1II10OIIIII:INTEGER:=0;CONSTANT IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII:INTEGER:=0;TYPE
 IIIIl1100lOI0I1OO1I00OlI0l10IIIIII IS ARRAY(0 TO IO1lll0I0l0l1ll1O01Ol0III011IOIIII-1)OF INTEGER;TYPE IOlI00I100IOOOl011O11IOI1l010IIIII IS ARRAY(0 TO 1)OF INTEGER;FUNCTION IIIO1O1110Oll10OI110OIIO111OOIIIII(
IIl0OIlO00I0lI101l1I0lO1II0IlIIIII,IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII:INTEGER)RETURN INTEGER;FUNCTION II11I0011I0IIIl0100l1O01O01O0IIIII(II011lO0O1l10O0I0OIOO000I0O1IOIIII:INTEGER)RETURN INTEGER;FUNCTION IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(IIlOllOOI0ll11O1101IIl0l11ll1IIIII,II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:
INTEGER)RETURN STD_LOGIC_VECTOR;FUNCTION III1OO10l11110IO1IO0lOII0OO11IIIII(IO1O1llOO0IlllI1O1OlOI010l1IIIIIII:STD_LOGIC_VECTOR)RETURN STD_LOGIC_VECTOR;FUNCTION IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII(II1IO01lI1IO1OII11O1II01I0llIOIIII,
II1lIII001001Il0l0OOl0I00I01IIIIII:INTEGER)RETURN INTEGER;FUNCTION II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII(IOII100I0I1l010IOI1lO1O1I1101IIIII:INTEGER)RETURN STRING;FUNCTION IOO10OI11Il110I11IIIIIOIO10OlIIIII(IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII:STRING
;IOl0l10lI11IO10lI1OI1IOI01OO0IIIII,IOO1l1010O10O10I0llO11O100O1IOIIII:INTEGER)RETURN INTEGER;FUNCTION IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II0IOOI1Il101lO1O010O0O0IO10IOIIII:STRING;IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII:INTEGER)RETURN INTEGER;END;PACKAGE BODY
 CONVOLUTION_PACK_V7_0 IS FUNCTION IIIO1O1110Oll10OI110OIIO111OOIIIII(IIl0OIlO00I0lI101l1I0lO1II0IlIIIII,IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII:INTEGER)RETURN INTEGER IS VARIABLE IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII,II111OIOII1IIOOOlO1I011OI0I0lIIIII:INTEGER;
BEGIN IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII:=0;II111OIOII1IIOOOlO1I011OI0I0lIIIII:=IIl0OIlO00I0lI101l1I0lO1II0IlIIIII;FOR III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII IN 0 TO IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII-1 LOOP IF(II111OIOII1IIOOOlO1I011OI0I0lIIIII REM 2)=1 THEN IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII:=IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII+1;END IF
;II111OIOII1IIOOOlO1I011OI0I0lIIIII:=II111OIOII1IIOOOlO1I011OI0I0lIIIII/2;END LOOP;RETURN IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII;END;FUNCTION II11I0011I0IIIl0100l1O01O01O0IIIII(II011lO0O1l10O0I0OIOO000I0O1IOIIII:INTEGER)RETURN INTEGER IS VARIABLE IIIIlI10IO0IlIll11O0O1OII0OIIOIIII:
INTEGER;VARIABLE IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII:INTEGER:=II011lO0O1l10O0I0OIOO000I0O1IOIIII;BEGIN IIIIlI10IO0IlIll11O0O1OII0OIIOIIII:=0;FOR IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII IN 0 TO 32-1 LOOP IF((IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII MOD 2)=1)THEN IIIIlI10IO0IlIll11O0O1OII0OIIOIIII:=IIIIlI10IO0IlIll11O0O1OII0OIIOIIII+1;END IF;IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII:=IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII
/2;IF(IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII=0)THEN EXIT;END IF;END LOOP;RETURN IIIIlI10IO0IlIll11O0O1OII0OIIOIIII;END;FUNCTION IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(IIlOllOOI0ll11O1101IIl0l11ll1IIIII,II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:INTEGER)RETURN
 STD_LOGIC_VECTOR IS VARIABLE IIl1O1I0001l1001OllOOII0I10l1IIIII:INTEGER:=IIlOllOOI0ll11O1101IIl0l11ll1IIIII;VARIABLE IIlIlll0III10I0Il0I0OOOIOIIOOIIIII:STD_LOGIC_VECTOR(II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII-1 DOWNTO 0);BEGIN IF(
IIlOllOOI0ll11O1101IIl0l11ll1IIIII<0)THEN IIl1O1I0001l1001OllOOII0I10l1IIIII:=-1*IIlOllOOI0ll11O1101IIl0l11ll1IIIII;END IF;FOR IOOI10l0O1lIlIll00Ol1lll10IIIIIIII IN 0 TO II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII-1 LOOP IF IIl1O1I0001l1001OllOOII0I10l1IIIII MOD 2=0 THEN IIlIlll0III10I0Il0I0OOOIOIIOOIIIII(IOOI10l0O1lIlIll00Ol1lll10IIIIIIII):='0';ELSE
 IIlIlll0III10I0Il0I0OOOIOIIOOIIIII(IOOI10l0O1lIlIll00Ol1lll10IIIIIIII):='1';END IF;IIl1O1I0001l1001OllOOII0I10l1IIIII:=IIl1O1I0001l1001OllOOII0I10l1IIIII/2;END LOOP;IF(IIlOllOOI0ll11O1101IIl0l11ll1IIIII<0)THEN RETURN III1OO10l11110IO1IO0lOII0OO11IIIII(IIlIlll0III10I0Il0I0OOOIOIIOOIIIII);ELSE RETURN
 IIlIlll0III10I0Il0I0OOOIOIIOOIIIII;END IF;END;FUNCTION III1OO10l11110IO1IO0lOII0OO11IIIII(IO1O1llOO0IlllI1O1OlOI010l1IIIIIII:STD_LOGIC_VECTOR)RETURN STD_LOGIC_VECTOR IS VARIABLE IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII:STD_LOGIC_VECTOR(
IO1O1llOO0IlllI1O1OlOI010l1IIIIIII'HIGH DOWNTO 0);VARIABLE IOl0I10010lIIIl000I1O1IO1IlOIIIIII:INTEGER:=0;BEGIN FOR IOl1I1O0IIO001llOlll1I1lOI1l0IIIII IN 0 TO IO1O1llOO0IlllI1O1OlOI010l1IIIIIII'HIGH LOOP IF(IOl0I10010lIIIl000I1O1IO1IlOIIIIII=1)THEN IF(IO1O1llOO0IlllI1O1OlOI010l1IIIIIII(IOl1I1O0IIO001llOlll1I1lOI1l0IIIII)='0')THEN IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII(IOl1I1O0IIO001llOlll1I1lOI1l0IIIII
):='1';ELSE IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII(IOl1I1O0IIO001llOlll1I1lOI1l0IIIII):='0';END IF;ELSE IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII(IOl1I1O0IIO001llOlll1I1lOI1l0IIIII):=IO1O1llOO0IlllI1O1OlOI010l1IIIIIII(IOl1I1O0IIO001llOlll1I1lOI1l0IIIII);IF(IO1O1llOO0IlllI1O1OlOI010l1IIIIIII(IOl1I1O0IIO001llOlll1I1lOI1l0IIIII)='1')THEN IOl0I10010lIIIl000I1O1IO1IlOIIIIII:=1;END IF;END IF;END LOOP;RETURN
 IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII;END;FUNCTION IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII(II1IO01lI1IO1OII11O1II01I0llIOIIII,II1lIII001001Il0l0OOl0I00I01IIIIII:INTEGER)RETURN INTEGER IS VARIABLE IOl1Ol11IlIl0110l0OOll000lI11IIIII:INTEGER:=0;BEGIN IF(II1IO01lI1IO1OII11O1II01I0llIOIIII
=0)THEN IOl1Ol11IlIl0110l0OOll000lI11IIIII:=1;ELSE IF(II1lIII001001Il0l0OOl0I00I01IIIIII=0)THEN IOl1Ol11IlIl0110l0OOll000lI11IIIII:=3;ELSE IOl1Ol11IlIl0110l0OOll000lI11IIIII:=1;END IF;END IF;RETURN IOl1Ol11IlIl0110l0OOll000lI11IIIII;END;FUNCTION
 II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII(IOII100I0I1l010IOI1lO1O1I1101IIIII:INTEGER)RETURN STRING IS VARIABLE II001Il0III1O1OI001IOI100000OIIIII:INTEGER;VARIABLE IOOl0llO0OI110111OIOlOIO0lOOIOIIII:INTEGER;VARIABLE II1IOO1l1I11I1ll1OI1I00lII000IIIII:INTEGER:=0;
VARIABLE II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:INTEGER;VARIABLE IOOl0IOOO1011llOIOl01lIOI0O11IIIII:INTEGER;CONSTANT IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:STRING(1 TO 10):="0123456789";VARIABLE II1I0O0100lIIII11lI00l0OOII0lIIIII:STRING(1 TO 11);
BEGIN IF IOII100I0I1l010IOI1lO1O1I1101IIIII<0 THEN IF IOII100I0I1l010IOI1lO1O1I1101IIIII<-2147483647 THEN RETURN("less than VHDL minimum INTEGER value");ELSE IOOl0llO0OI110111OIOlOIO0lOOIOIIII:=-1*IOII100I0I1l010IOI1lO1O1I1101IIIII;
IOOl0IOOO1011llOIOl01lIOI0O11IIIII:=1;II1I0O0100lIIII11lI00l0OOII0lIIIII(1):='-';END IF;ELSE IOOl0llO0OI110111OIOlOIO0lOOIOIIII:=IOII100I0I1l010IOI1lO1O1I1101IIIII;IOOl0IOOO1011llOIOl01lIOI0O11IIIII:=0;END IF;IF(IOOl0llO0OI110111OIOlOIO0lOOIOIIII=0)THEN RETURN"0";ELSIF(IOOl0llO0OI110111OIOlOIO0lOOIOIIII<10)THEN
 II1IOO1l1I11I1ll1OI1I00lII000IIIII:=1+IOOl0IOOO1011llOIOl01lIOI0O11IIIII;ELSIF(IOOl0llO0OI110111OIOlOIO0lOOIOIIII<100)THEN II1IOO1l1I11I1ll1OI1I00lII000IIIII:=2+IOOl0IOOO1011llOIOl01lIOI0O11IIIII;ELSIF(IOOl0llO0OI110111OIOlOIO0lOOIOIIII<1000)THEN II1IOO1l1I11I1ll1OI1I00lII000IIIII:=3+IOOl0IOOO1011llOIOl01lIOI0O11IIIII;ELSIF(IOOl0llO0OI110111OIOlOIO0lOOIOIIII<10000)
THEN II1IOO1l1I11I1ll1OI1I00lII000IIIII:=4+IOOl0IOOO1011llOIOl01lIOI0O11IIIII;ELSIF(IOOl0llO0OI110111OIOlOIO0lOOIOIIII<100000)THEN II1IOO1l1I11I1ll1OI1I00lII000IIIII:=5+IOOl0IOOO1011llOIOl01lIOI0O11IIIII;ELSIF(IOOl0llO0OI110111OIOlOIO0lOOIOIIII<1000000)THEN II1IOO1l1I11I1ll1OI1I00lII000IIIII:=6+IOOl0IOOO1011llOIOl01lIOI0O11IIIII;ELSIF(
IOOl0llO0OI110111OIOlOIO0lOOIOIIII<10000000)THEN II1IOO1l1I11I1ll1OI1I00lII000IIIII:=7+IOOl0IOOO1011llOIOl01lIOI0O11IIIII;ELSIF(IOOl0llO0OI110111OIOlOIO0lOOIOIIII<100000000)THEN II1IOO1l1I11I1ll1OI1I00lII000IIIII:=8+IOOl0IOOO1011llOIOl01lIOI0O11IIIII;ELSIF(IOOl0llO0OI110111OIOlOIO0lOOIOIIII<1000000000)THEN II1IOO1l1I11I1ll1OI1I00lII000IIIII:=9+
IOOl0IOOO1011llOIOl01lIOI0O11IIIII;ELSE II1IOO1l1I11I1ll1OI1I00lII000IIIII:=10+IOOl0IOOO1011llOIOl01lIOI0O11IIIII;END IF;IF(II1IOO1l1I11I1ll1OI1I00lII000IIIII>0)THEN II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=II1IOO1l1I11I1ll1OI1I00lII000IIIII;WHILE(IOOl0llO0OI110111OIOlOIO0lOOIOIIII/=0)LOOP II001Il0III1O1OI001IOI100000OIIIII:=IOOl0llO0OI110111OIOlOIO0lOOIOIIII MOD 10;II1I0O0100lIIII11lI00l0OOII0lIIIII(
II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII):=IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II001Il0III1O1OI001IOI100000OIIIII+1);IOOl0llO0OI110111OIOlOIO0lOOIOIIII:=IOOl0llO0OI110111OIOlOIO0lOOIOIIII/10;II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII-1;END LOOP;END IF;RETURN II1I0O0100lIIII11lI00l0OOII0lIIIII(1 TO II1IOO1l1I11I1ll1OI1I00lII000IIIII);END;FUNCTION IOO10OI11Il110I11IIIIIOIO10OlIIIII(IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII:
STRING;IOl0l10lI11IO10lI1OI1IOI01OO0IIIII,IOO1l1010O10O10I0llO11O100O1IOIIII:INTEGER)RETURN INTEGER IS BEGIN IF IOO1l1010O10O10I0llO11O100O1IOIIII/=0 THEN ASSERT FALSE REPORT IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII&II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII(IOl0l10lI11IO10lI1OI1IOI01OO0IIIII)&
II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY NOTE;END IF;RETURN 1;END;FUNCTION IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II0IOOI1Il101lO1O010O0O0IO10IOIIII:STRING;IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII:INTEGER)RETURN INTEGER IS BEGIN IF
 IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII/=0 THEN ASSERT FALSE REPORT II1IOOO1II0l1lOl00I1O001I00O0IIIII&II0IOOI1Il101lO1O010O0O0IO10IOIIII SEVERITY NOTE;END IF;RETURN 1;END;END;LIBRARY IEEE;USE IEEE.STD_LOGIC_1164.ALL
;LIBRARY STD;USE STD.TEXTIO.ALL;LIBRARY XILINXCORELIB;USE XILINXCORELIB.BIP_UTILS_PKG_V2_0.ALL;USE XILINXCORELIB.
CONVOLUTION_PACK_V7_0.ALL;ENTITY CONVOLUTION_V7_0 IS GENERIC(C_OUTPUT_RATE:INTEGER:=IOOOlI0llOIl11IO01100OI1llOIIOIIII;C_CONSTRAINT_LENGTH:INTEGER
:=IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII;C_PUNCTURED:INTEGER:=II1001IO0010Oll1I01lOI0I0IlIOIIIII;C_DUAL_CHANNEL:INTEGER:=0;C_PUNC_INPUT_RATE:INTEGER:=
IO110I1O0010OIOlIO00l1IIOl0llIIIII;C_PUNC_OUTPUT_RATE:INTEGER:=IIIOOIO01011011IOIIlllIIOO0l1IIIII;C_CONVOLUTION_CODE0:INTEGER:=II1IOOO00I0OI0O01I000O100llOOIIIII
;C_CONVOLUTION_CODE1:INTEGER:=II00OI0110lI1II101lO1OO00I10OIIIII;C_CONVOLUTION_CODE2:INTEGER:=II00OIlIlO101I0IIOO0O1I0ll0OIIIIII;C_CONVOLUTION_CODE3
:INTEGER:=IOOI1l1OO01O111lO010OlO1O0l0IIIIII;C_CONVOLUTION_CODE4:INTEGER:=IO11OllII1lO110Ol0I0O00I01l00IIIII;C_CONVOLUTION_CODE5:INTEGER:=
III01lO1l00IOOO0O0I0O0I111O0IIIIII;C_CONVOLUTION_CODE6:INTEGER:=IO1I1l01l1OI111Ol0IO10110I11IOIIII;C_PUNC_CODE0:INTEGER:=IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII;
C_PUNC_CODE1:INTEGER:=IIIOI11O0OO00OllOllO00lOI000IOIIII;C_HAS_ND:INTEGER:=IIOIOOO11l0lO001OI10I0IIIIlIIIIIII;C_HAS_RFD:INTEGER:=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII;C_HAS_RDY:INTEGER
:=IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII;C_HAS_FD:INTEGER:=II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII;C_HAS_RFFD:INTEGER:=IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII;C_HAS_CE:INTEGER:=IO0O10O101OOIOOl10lIIO101lIIIIIIII;C_HAS_SCLR
:INTEGER:=IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII;C_FAMILY:STRING:="virtex5";C_XDEVICEFAMILY:STRING:="virtex5");PORT(DATA_IN:IN STD_LOGIC:='0';DATA_OUT_V:
OUT STD_LOGIC_VECTOR(C_OUTPUT_RATE-1 DOWNTO 0);DATA_OUT_S:OUT STD_LOGIC;FD_IN:IN STD_LOGIC:='0';ND:IN STD_LOGIC:='0';RFD:OUT
 STD_LOGIC;RFFD:OUT STD_LOGIC;RDY:OUT STD_LOGIC;CE:IN STD_LOGIC:='0';SCLR:IN STD_LOGIC:='0';CLK:IN STD_LOGIC:='0');END;ARCHITECTURE
 BEHAVIORAL OF CONVOLUTION_V7_0 IS CONSTANT IIOIOI0lO1lO100O11Il0OII11OlOIIIII:INTEGER:=C_PUNC_INPUT_RATE*2;CONSTANT IO0IlO1lI10Il011101l101IIl0IOIIIII:INTEGER:=
C_PUNC_OUTPUT_RATE;CONSTANT IOI1O00I10101l0I1001llOOI0I0IOIIII:TIME:=1 NS;FUNCTION IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII(IO1Il1I0OOOOIl0IOO011l1I0111OIIIII:INTEGER)RETURN INTEGER IS VARIABLE IO0l0IOllOl1100O10O1O1l0lIO1OIIIII:INTEGER:=0
;VARIABLE IIlOO000I01110Ill0l1OI1l10IOIOIIII:INTEGER:=IO1Il1I0OOOOIl0IOO011l1I0111OIIIII;BEGIN FOR II1011O1IO1l0llOI11lIIOIlOlIlIIIII IN 0 TO C_CONSTRAINT_LENGTH-1 LOOP IO0l0IOllOl1100O10O1O1l0lIO1OIIIII:=2*IO0l0IOllOl1100O10O1O1l0lIO1OIIIII;IF(IIlOO000I01110Ill0l1OI1l10IOIOIIII REM 2=1)THEN
 IO0l0IOllOl1100O10O1O1l0lIO1OIIIII:=IO0l0IOllOl1100O10O1O1l0lIO1OIIIII+1;END IF;IIlOO000I01110Ill0l1OI1l10IOIOIIII:=IIlOO000I01110Ill0l1OI1l10IOIOIIII/2;END LOOP;RETURN IO0l0IOllOl1100O10O1O1l0lIO1OIIIII;END;FUNCTION IOO0I1l1IOO0II0O00I0IllOOI1OOIIIII(IOI01l1I0000lIO0IIO01IlIO1001IIIII:INTEGER;IOI0IIll0I0l1IO0I01lO110IIIIIOIIII:
IOlI00I100IOOOl011O11IOI1l010IIIII;IO00l1I0I1IOlII011Il0l0lOI0OIIIIII,IO01l1ll0IlOll0I00lll11l0OllIIIIII:INTEGER)RETURN INTEGER IS VARIABLE IOI11IOIlOI1II1Il11OlI01Illl0IIIII:IOlI00I100IOOOl011O11IOI1l010IIIII:=IOI0IIll0I0l1IO0I01lO110IIIIIOIIII;VARIABLE
 IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII:INTEGER:=0;BEGIN FOR IOlIOOI0O1OIlOl01O0OIII10O11lIIIII IN 0 TO C_PUNC_INPUT_RATE-1 LOOP FOR IO1OIOI0I1l11O0IllIOllII1llIIOIIII IN 0 TO IO00l1I0I1IOlII011Il0l0lOI0OIIIIII-1 LOOP IF(IOI11IOIlOI1II1Il11OlI01Illl0IIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII)MOD 2=1)THEN IF(
IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII=IOI01l1I0000lIO0IIO01IlIO1001IIIII)THEN RETURN IO1OIOI0I1l11O0IllIOllII1llIIOIIII;END IF;IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII:=IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII+1;END IF;IOI11IOIlOI1II1Il11OlI01Illl0IIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII):=IOI11IOIlOI1II1Il11OlI01Illl0IIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII)/2;END LOOP;EXIT WHEN(IOI11IOIlOI1II1Il11OlI01Illl0IIIII(0)=0 AND IOI11IOIlOI1II1Il11OlI01Illl0IIIII(1)=0);END
 LOOP;RETURN 0;END;FUNCTION IIOOO0OOIll110IlI1111I1001I01IIIII(IO00lII1lIll0OllOlI1l1O0OI100IIIII:INTEGER;IIII1llIll1l01O1l1O0OIlO1l00OIIIII:IOlI00I100IOOOl011O11IOI1l010IIIII;II10ll00IlO1IIOIOIO10II0lI1l0IIIII,IOIIOIIO1lIIOOl0IlO11I00II110IIIII:INTEGER)RETURN
 INTEGER IS VARIABLE II0Ol0OI111lIO001O0IIlO110IlIOIIII:IOlI00I100IOOOl011O11IOI1l010IIIII:=IIII1llIll1l01O1l1O0OIlO1l00OIIIII;VARIABLE II1ll00lO01110lOI1I0IOO0IlO0IIIIII:INTEGER:=0;BEGIN FOR IO0I011OOl0OOO000O0I0O0OO0OllIIIII IN 0 TO C_PUNC_INPUT_RATE-1 LOOP
 FOR IO1OllI0IIll0OIOI1l01I010OOIOOIIII IN 0 TO II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1 LOOP IF(II0Ol0OI111lIO001O0IIlO110IlIOIIII(IO1OllI0IIll0OIOI1l01I010OOIOOIIII)MOD 2=1)THEN IF(II1ll00lO01110lOI1I0IOO0IlO0IIIIII=IO00lII1lIll0OllOlI1l1O0OI100IIIII)THEN RETURN C_PUNC_INPUT_RATE-1-IO0I011OOl0OOO000O0I0O0OO0OllIIIII;END IF;II1ll00lO01110lOI1I0IOO0IlO0IIIIII:=
II1ll00lO01110lOI1I0IOO0IlO0IIIIII+1;END IF;II0Ol0OI111lIO001O0IIlO110IlIOIIII(IO1OllI0IIll0OIOI1l01I010OOIOOIIII):=II0Ol0OI111lIO001O0IIlO110IlIOIIII(IO1OllI0IIll0OIOI1l01I010OOIOOIIII)/2;END LOOP;EXIT WHEN(II0Ol0OI111lIO001O0IIlO110IlIOIIII(0)=0 AND II0Ol0OI111lIO001O0IIlO110IlIOIIII(1)=0);END LOOP;RETURN 0;END;FUNCTION IIOl11l1l101llOl0l0l101I1O1llIIIII(
III1O0Ol0IOOO0IllIOOO000O1lO0IIIII,IIl1IIO111llI0l1O1OI00lIl1I0OIIIII:INTEGER;IIIOOI1II1O11lOIOlOIlOOII1010IIIII:IOlI00I100IOOOl011O11IOI1l010IIIII;IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII,IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII:INTEGER)RETURN INTEGER IS VARIABLE IOOI0OO0l1O1O000lO10OOllOIIIIOIIII:
IOlI00I100IOOOl011O11IOI1l010IIIII:=IIIOOI1II1O11lOIOlOIlOOII1010IIIII;VARIABLE IO1IllOO0II1ll1OII0OOO10OO0I1IIIII:INTEGER:=0;VARIABLE IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII:INTEGER:=IIl1IIO111llI0l1O1OI00lIl1I0OIIIII*2+III1O0Ol0IOOO0IllIOOO000O1lO0IIIII;BEGIN FOR IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII IN 0 TO
 IIOIOI0lO1lO100O11Il0OII11OlOIIIII-1 LOOP FOR II10110Oll1OOlIOlOlIl01111IlOIIIII IN 0 TO IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII-1 LOOP IF(IOOI0OO0l1O1O000lO10OOllOIIIIOIIII(II10110Oll1OOlIOlOlIl01111IlOIIIII)REM 2=1)THEN IF(IO1IllOO0II1ll1OII0OOO10OO0I1IIIII=IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII)THEN RETURN II10110Oll1OOlIOlOlIl01111IlOIIIII;END IF;IO1IllOO0II1ll1OII0OOO10OO0I1IIIII:=
IO1IllOO0II1ll1OII0OOO10OO0I1IIIII+1;END IF;IOOI0OO0l1O1O000lO10OOllOIIIIOIIII(II10110Oll1OOlIOlOlIl01111IlOIIIII):=IOOI0OO0l1O1O000lO10OOllOIIIIOIIII(II10110Oll1OOlIOlOlIl01111IlOIIIII)/2;END LOOP;EXIT WHEN(IOOI0OO0l1O1O000lO10OOllOIIIIOIIII(0)=0 AND IOOI0OO0l1O1O000lO10OOllOIIIIOIIII(1)=0);END LOOP;RETURN 0;END;FUNCTION IOIO00lO11l0IOO1l0I101I11l1OOIIIII(
IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII,II0l0O0IOlIOI00OIl0IlOlI01OI1IIIII:INTEGER;IIlO0l11I10OOIl000I0OOIO0IO0IIIIII:IOlI00I100IOOOl011O11IOI1l010IIIII;IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII,IOIlllIIlI1OlI0l101llI0II1O1IOIIII:INTEGER)RETURN INTEGER IS VARIABLE IOO0IO0OOOOO0I10II0llO10ll1OlIIIII:
IOlI00I100IOOOl011O11IOI1l010IIIII:=IIlO0l11I10OOIl000I0OOIO0IO0IIIIII;VARIABLE IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII:INTEGER:=0;VARIABLE IOl10OI01O100l1IIIl0IIl1lO10lIIIII:INTEGER:=2*II0l0O0IOlIOI00OIl0IlOlI01OI1IIIII+IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII;BEGIN FOR IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII IN 0 TO
 IIOIOI0lO1lO100O11Il0OII11OlOIIIII-1 LOOP FOR IO00l1II1l000l0I11O010I1IlOlIOIIII IN 0 TO IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII-1 LOOP IF(IOO0IO0OOOOO0I10II0llO10ll1OlIIIII(IO00l1II1l000l0I11O010I1IlOlIOIIII)REM 2=1)THEN IF(IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII=IOl10OI01O100l1IIIl0IIl1lO10lIIIII)THEN RETURN IIOIOI0lO1lO100O11Il0OII11OlOIIIII-1-IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII;END
 IF;IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII:=IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII+1;END IF;IOO0IO0OOOOO0I10II0llO10ll1OlIIIII(IO00l1II1l000l0I11O010I1IlOlIOIIII):=IOO0IO0OOOOO0I10II0llO10ll1OlIIIII(IO00l1II1l000l0I11O010I1IlOlIOIIII)/2;END LOOP;EXIT WHEN(IOO0IO0OOOOO0I10II0llO10ll1OlIIIII(0)=0 AND IOO0IO0OOOOO0I10II0llO10ll1OlIIIII(1)=0);END LOOP;RETURN 0;END;CONSTANT
 II0IO0O1III0I1I1OlI0011O001IOIIIII:INTEGER:=C_OVERRIDE;SIGNAL IIl1OOO111O0O11l1OOllOIIIIIl0IIIII,IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII,IOl1I001lIl1Il1I11lI00l11O1OOIIIII,IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII:STD_LOGIC;SIGNAL IOO01101I01OlOIO111IIl0OOIOI0IIIII:STD_LOGIC_VECTOR(C_OUTPUT_RATE
-1 DOWNTO 0):=(OTHERS=>'0');SIGNAL II00l0IOI1lIlOlOOI0I011O1110OIIIII,IOIO1OI0IlI1I1010lO000IO01Ol0IIIII:STD_LOGIC_VECTOR(C_OUTPUT_RATE-1 DOWNTO 0):=(OTHERS=>'0');SIGNAL
 IIO00Il10lI0OOllOOO0lO11lOOlIOIIII:STD_LOGIC:='1';SIGNAL IIIIOOlIIO11011I1IlOO10OOOO0OIIIII:STD_LOGIC:='1';SIGNAL IIO0101IlI11I0IOlI01l1ll0O10OIIIII,IOl00OIO0IOOllO1I1O101lIIl11OIIIII:STD_LOGIC;SIGNAL IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII,IO00OI0ll1l1l0llI1I000OOO0010IIIII,IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII:STD_LOGIC;SIGNAL
 IOI0111Il0IllIIO0O0lO0I111010IIIII,IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII:STD_LOGIC;SIGNAL IOO0llOIlIO0110l1lOO01I00l1OIIIIII,IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IO0lI0OlO11O10O1III000O01l0l0IIIII:STD_LOGIC;SIGNAL IIO1O00llO01OII1I11lIIO001lI0IIIII,IOIl1lI1IO111IO0OII101O1I0l0IOIIII,IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII:STD_LOGIC;SIGNAL
 IO01O100lOO0IOOI000OO1lIOO1l0IIIII:STD_LOGIC;SIGNAL IOl1100I00OlIllOI1I0III1O1l01IIIII:STD_LOGIC_VECTOR(C_OUTPUT_RATE-1 DOWNTO 0);SIGNAL IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII:STD_LOGIC;SIGNAL
 IIOIlOO1lI01O10O1Ol0OOI10110OIIIII:STD_LOGIC;SIGNAL IO0II1lll1llOlO1lll1001O1IlOIOIIII:STD_LOGIC;SIGNAL IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:STD_LOGIC;SIGNAL IIlIIII1lOllO0IlO11I1O01110IOIIIII:STD_LOGIC;SIGNAL
 II0I1I1l00l1O11OOIOIIllII10IlIIIII:STD_LOGIC;SIGNAL III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII:STD_LOGIC;SIGNAL III010I1Ol1OlOI0IO10O0000II11IIIII:STD_LOGIC;SIGNAL IOIlOO00I1I00lO00l0I00OlIO01IIIIII:
STD_LOGIC;SIGNAL IIO111Il00001lO0l00lOOlI1IO10IIIII:STD_LOGIC;SIGNAL II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:STD_LOGIC;SIGNAL IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII:STD_LOGIC;SIGNAL IO0I10OO0llIIlII1I01OOI001IIIIIIII:
STD_LOGIC;SIGNAL II110IlI0l101IO1IlI1O00llI00OIIIII:STD_LOGIC;SIGNAL III0O000IO1IOIO10l0I00lOIII11IIIII:STD_LOGIC;SIGNAL II1llIOlOlll00O010O1lI1IOI1I1IIIII:STD_LOGIC_VECTOR(7 DOWNTO 0);SIGNAL
 IO1I11OIllI1III1III11OlIIlIIOIIIII:STD_LOGIC_VECTOR(7 DOWNTO 0);SIGNAL IIl11lIlOO0IIII0IOlI0l1000I1IIIIII:STD_LOGIC_VECTOR(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO 0);SIGNAL
 IOOI10l11llO01llIIllOI1IO0l1OIIIII:STD_LOGIC_VECTOR(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO 0);SIGNAL IOO1IIll11IlI110IOlllI1Il1IO1IIIII:STD_LOGIC_VECTOR(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO 0);
SIGNAL IOO000O0Ol1OlIOOI00l11I1l1I00IIIII:STD_LOGIC_VECTOR(C_PUNC_INPUT_RATE-1 DOWNTO 0);SIGNAL IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:STD_LOGIC_VECTOR(C_CONSTRAINT_LENGTH-1
 DOWNTO 0);TYPE IIOI10lI0II00O0IOOl0I10001lO1IIIII IS ARRAY(0 TO C_OUTPUT_RATE-1)OF STD_LOGIC_VECTOR(C_PUNC_INPUT_RATE-1 DOWNTO 0);SIGNAL IIO1IIOOO0OO1100OO11l0OOllIIIOIIII,
IOO01O011lIIIlOl1O0lOIOOI110IOIIII:IIOI10lI0II00O0IOOl0I10001lO1IIIII;BEGIN CHECK_GENERICS:PROCESS VARIABLE IOIOO101OO01Ol1101l1O01O1OOllIIIII:INTEGER:=(2**C_CONSTRAINT_LENGTH)-1;BEGIN IF(C_CONSTRAINT_LENGTH
>IOO0111OO0lOOl10l1l000l0OlI0IIIIII)THEN ASSERT FALSE REPORT"Selected constraint length is "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_OUTPUT_RATE<2 OR
 C_OUTPUT_RATE>IO1lll0I0l0l1ll1O01Ol0III011IOIIII)THEN ASSERT FALSE REPORT"Output rate for encoder must be between 2 and 7 "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;
END IF;IF((IIIO1O1110Oll10OI110OIIO111OOIIIII(C_CONVOLUTION_CODE0,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE0>IOIOO101OO01Ol1101l1O01O1OOllIIIII))THEN ASSERT FALSE REPORT
"Convolution code 0 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE0=0)AND(C_OUTPUT_RATE>0
))THEN ASSERT FALSE REPORT"Convolution code 0 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIIO1O1110Oll10OI110OIIO111OOIIIII(
C_CONVOLUTION_CODE1,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE1>IOIOO101OO01Ol1101l1O01O1OOllIIIII))THEN ASSERT FALSE REPORT
"Convolution code 1 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE1=0)AND(C_OUTPUT_RATE>1
))THEN ASSERT FALSE REPORT"Convolution code 1 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIIO1O1110Oll10OI110OIIO111OOIIIII(
C_CONVOLUTION_CODE2,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE2>IOIOO101OO01Ol1101l1O01O1OOllIIIII))THEN ASSERT FALSE REPORT
"Convolution code 2 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE2=0)AND(C_OUTPUT_RATE>2
))THEN ASSERT FALSE REPORT"Convolution code 2 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIIO1O1110Oll10OI110OIIO111OOIIIII(
C_CONVOLUTION_CODE3,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE3>IOIOO101OO01Ol1101l1O01O1OOllIIIII))THEN ASSERT FALSE REPORT
"Convolution code 3 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE3=0)AND(C_OUTPUT_RATE>3
))THEN ASSERT FALSE REPORT"Convolution code 3 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIIO1O1110Oll10OI110OIIO111OOIIIII(
C_CONVOLUTION_CODE4,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE4>IOIOO101OO01Ol1101l1O01O1OOllIIIII))THEN ASSERT FALSE REPORT
"Convolution code 4 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE4=0)AND(C_OUTPUT_RATE>4
))THEN ASSERT FALSE REPORT"Convolution code 4 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIIO1O1110Oll10OI110OIIO111OOIIIII(
C_CONVOLUTION_CODE5,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE5>IOIOO101OO01Ol1101l1O01O1OOllIIIII))THEN ASSERT FALSE REPORT
"Convolution code 5 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE5=0)AND(C_OUTPUT_RATE>5
))THEN ASSERT FALSE REPORT"Convolution code 5 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIIO1O1110Oll10OI110OIIO111OOIIIII(
C_CONVOLUTION_CODE6,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE6>IOIOO101OO01Ol1101l1O01O1OOllIIIII))THEN ASSERT FALSE REPORT
"Convolution code 6 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE6=0)AND(C_OUTPUT_RATE>6
))THEN ASSERT FALSE REPORT"Convolution code 6 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_PUNCTURED=0)THEN IF(
C_HAS_FD/=0)THEN ASSERT FALSE REPORT"FD cannot be present in non-punctured coding "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_HAS_RFFD/=0
)THEN ASSERT FALSE REPORT"RFFD cannot be present in non-punctured coding "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;END IF;IF(C_PUNCTURED=1)
THEN IF((C_PUNC_OUTPUT_RATE>(2*C_PUNC_INPUT_RATE-1))AND(C_PUNC_OUTPUT_RATE<C_PUNC_INPUT_RATE+1))THEN ASSERT FALSE REPORT
"Invalid punctured output rate: must be greater than "&II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII(C_PUNC_INPUT_RATE)&" less than "&II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII(2*
C_PUNC_INPUT_RATE)&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_OUTPUT_RATE/=2)THEN ASSERT FALSE REPORT
"Output rate must be equal to 2 for puncture "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_PUNC_INPUT_RATE>IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII)THEN ASSERT
 FALSE REPORT"Punc Input rate must be less than or equal to "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(IIIO1O1110Oll10OI110OIIO111OOIIIII(C_PUNC_CODE0,32)>
C_PUNC_INPUT_RATE)THEN ASSERT FALSE REPORT"Puncture code 0 length can not exceed "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(IIIO1O1110Oll10OI110OIIO111OOIIIII(
C_PUNC_CODE1,32)>C_PUNC_INPUT_RATE)THEN ASSERT FALSE REPORT"Puncture code 1 length can not exceed "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;
IF(II11I0011I0IIIl0100l1O01O01O0IIIII(C_PUNC_CODE0)+II11I0011I0IIIl0100l1O01O01O0IIIII(C_PUNC_CODE1)/=(C_PUNC_OUTPUT_RATE))THEN ASSERT FALSE REPORT
"Invalid punture codes - number of total 1's in puncture code must be "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_HAS_ND/=1 AND
 C_DUAL_CHANNEL=0)THEN ASSERT FALSE REPORT"ND signal required for punctured coding "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_HAS_RFD/=1
 AND C_DUAL_CHANNEL=0)THEN ASSERT FALSE REPORT"RFD signal required for punctured coding "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(
C_HAS_RDY/=1)THEN ASSERT FALSE REPORT"RDY signal required for punctured coding "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;END IF;WAIT;END
 PROCESS;GENERATE_INPUTS:PROCESS(DATA_IN,SCLR,CE,FD_IN,ND)BEGIN IIl1OOO111O0O11l1OOllOIIIIIl0IIIII<=DATA_IN;IF(C_HAS_SCLR=1)THEN III0l0O0I11OOO1lI0OOIO0llOlIlIIIII<=SCLR;ELSE III0l0O0I11OOO1lI0OOIO0llOlIlIIIII<=
'0';END IF;IF(C_HAS_CE=1)THEN IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII<=CE;ELSE IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII<='1';END IF;IF(C_HAS_ND=1)THEN IOl1I001lIl1Il1I11lI00l11O1OOIIIII<=ND;ELSE IOl1I001lIl1Il1I11lI00l11O1OOIIIII<='1';END IF;IF(C_HAS_FD=1)THEN
 IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII<=FD_IN;ELSE IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII<='0';END IF;END PROCESS;CONVOLVE:PROCESS(CLK,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII,IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII,IOl1I001lIl1Il1I11lI00l11O1OOIIIII,IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII,IIO00Il10lI0OOllOOO0lO11lOOlIOIIII)VARIABLE IIOO0IIlO0O0I01l00I1011II0011IIIII:
STD_LOGIC_VECTOR(C_CONSTRAINT_LENGTH-1 DOWNTO 0):=(OTHERS=>'0');VARIABLE IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII:STD_LOGIC_VECTOR(C_OUTPUT_RATE-1 DOWNTO 0);
VARIABLE IIOlI0O00IO011lIIOl100O001lIOOIIII:STD_LOGIC_VECTOR(C_OUTPUT_RATE-1 DOWNTO 0);VARIABLE III0IlIOll1Ill0I0I0OlIO10I1I1IIIII:IIIIl1100lOI0I1OO1I00OlI0l10IIIIII:=(IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII(
C_CONVOLUTION_CODE0),IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII(C_CONVOLUTION_CODE1),IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII(C_CONVOLUTION_CODE2),IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII(C_CONVOLUTION_CODE3),
IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII(C_CONVOLUTION_CODE4),IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII(C_CONVOLUTION_CODE5),IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII(C_CONVOLUTION_CODE6));VARIABLE IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:
STD_LOGIC_VECTOR(C_CONSTRAINT_LENGTH-1 DOWNTO 0);VARIABLE II0I1O11OOll0l0I11O110OlI0lIOOIIII:STD_LOGIC;VARIABLE II1lI1l0l00llI0l0l1O0OOII10I1IIIII:BOOLEAN:=TRUE;BEGIN IF(II1lI1l0l00llI0l0l1O0OOII10I1IIIII)THEN
 II1lI1l0l00llI0l0l1O0OOII10I1IIIII:=FALSE;IOO01101I01OlOIO111IIl0OOIOI0IIIII<=(OTHERS=>'0');IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII:=(OTHERS=>'0');IIOlI0O00IO011lIIOl100O001lIOOIIII:=(OTHERS=>'0');END IF;IF(RISING_EDGE(CLK))THEN IF
(III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='0'AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1')THEN IIOlI0O00IO011lIIOl100O001lIOOIIII:=IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII;END IF;IF(III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='0'AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII='1')THEN
 IIOO0IIlO0O0I01l00I1011II0011IIIII(C_CONSTRAINT_LENGTH-1 DOWNTO 1):=IIOO0IIlO0O0I01l00I1011II0011IIIII(C_CONSTRAINT_LENGTH-2 DOWNTO 0);IIOO0IIlO0O0I01l00I1011II0011IIIII(0):=IIl1OOO111O0O11l1OOllOIIIIIl0IIIII;FOR II0l10llII1lO0O1lOIlOOI10I0lIIIIII IN 0 TO
 C_OUTPUT_RATE-1 LOOP II0I1O11OOll0l0I11O110OlI0lIOOIIII:='0';IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:=IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(III0IlIOll1Ill0I0I0OlIO10I1I1IIIII(II0l10llII1lO0O1lOIlOOI10I0lIIIIII),C_CONSTRAINT_LENGTH);FOR IO1I1OlOI1OII110llI1lI0IIl0O0IIIII IN 0 TO
 C_CONSTRAINT_LENGTH-1 LOOP II0I1O11OOll0l0I11O110OlI0lIOOIIII:=II0I1O11OOll0l0I11O110OlI0lIOOIIII XOR(IIOO0IIlO0O0I01l00I1011II0011IIIII(IO1I1OlOI1OII110llI1lI0IIl0O0IIIII)AND IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII(IO1I1OlOI1OII110llI1lI0IIl0O0IIIII));END LOOP;IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII(II0l10llII1lO0O1lOIlOOI10I0lIIIIII):=II0I1O11OOll0l0I11O110OlI0lIOOIIII;END LOOP
;ELSIF((III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1')AND(IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'))THEN IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII:=(OTHERS=>'0');IIOlI0O00IO011lIIOl100O001lIOOIIII:=(OTHERS=>'0');IIOO0IIlO0O0I01l00I1011II0011IIIII:=(OTHERS=>'0');END IF;END
 IF;IOO01101I01OlOIO111IIl0OOIOI0IIIII<=IIOlI0O00IO011lIIOl100O001lIOOIIII;IOIO1OI0IlI1I1010lO000IO01Ol0IIIII<=IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII;IIll0O11l1O1lOl111IIOlOIl0I0OIIIII<=IIOO0IIlO0O0I01l00I1011II0011IIIII;END PROCESS;PUNCTURE:PROCESS(CLK,
II00l0IOI1lIlOlOOI0I011O1110OIIIII,IOIl1lI1IO111IO0OII101O1I0l0IOIIII,IIO1O00llO01OII1I11lIIO001lI0IIIII,IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII,IOl1I001lIl1Il1I11lI00l11O1OOIIIII,IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII)VARIABLE II110IO0lllI1lOI110IO00I1lOlIIIIII:BOOLEAN:=TRUE;VARIABLE IIl110lllO10l0llOI11l01I0I1OlIIIII,IOOll11IO1O1llOIl10010O1IIOOIIIIII,IIII00I101O111lII1O000IO1lOOIIIIII:
IIOI10lI0II00O0IOOl0I10001lO1IIIII;VARIABLE IOOI01II11O1I1IOII1II01O1001lIIIII,IO111Il1I1O0lO1OlOI0l01I1O010IIIII:INTEGER;VARIABLE III011IIIl1IO1l0O11000I0llI00IIIII,II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII,IIO1l1Ol1l11Il0000II00lI011I0IIIII:STD_LOGIC;VARIABLE IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:STD_LOGIC;
VARIABLE II1lI11lI1II1000lOllIOl01l0l0IIIII:STD_LOGIC;VARIABLE II0l0001lI0I0IlllI1I100OO10IIIIIII:STD_LOGIC;VARIABLE II01l0llO10l10II111lIlOIllO0lIIIII:STD_LOGIC;VARIABLE IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII,IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII
,IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:STD_LOGIC_VECTOR(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO 0);VARIABLE II10l111IOllO0O1111Ill001lll1IIIII:IOlI00I100IOOOl011O11IOI1l010IIIII:=(C_PUNC_CODE0,C_PUNC_CODE1);VARIABLE
 IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII,IIll1lO0l0lI0OII00l00OO11IlO1IIIII:STD_LOGIC;VARIABLE III00O11l11IlIOI1llIIIOII100lIIIII:STD_LOGIC;VARIABLE IO1l01O110OIl00l10lOOlI0lI0I0IIIII:STD_LOGIC;VARIABLE IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:STD_LOGIC;
VARIABLE IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:STD_LOGIC;VARIABLE IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:STD_LOGIC;VARIABLE III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:STD_LOGIC;VARIABLE IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:STD_LOGIC;VARIABLE
 IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:STD_LOGIC;VARIABLE III11I01Ol11IOO00IOI1I11OOl10IIIII:INTEGER;VARIABLE IIl1lOIllIlIl01ll00O11OIl100IOIIII:INTEGER;BEGIN IF(C_PUNCTURED=1 AND C_DUAL_CHANNEL=0)THEN IF
(II110IO0lllI1lOI110IO00I1lOlIIIIII)THEN II110IO0lllI1lOI110IO00I1lOlIIIIII:=FALSE;FOR IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IIl110lllO10l0llOI11l01I0I1OlIIIII(IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII):=(OTHERS=>'0');IOOll11IO1O1llOIl10010O1IIOOIIIIII(IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII):=(OTHERS=>'0');IIII00I101O111lII1O000IO1lOOIIIIII(IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII)
:=(OTHERS=>'0');END LOOP;IOOI01II11O1I1IOII1II01O1001lIIIII:=0;IO111Il1I1O0lO1OlOI0l01I1O010IIIII:=0;III11I01Ol11IOO00IOI1I11OOl10IIIII:=0;III011IIIl1IO1l0O11000I0llI00IIIII:='0';IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:='0';II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:='0';
II1lI11lI1II1000lOllIOl01l0l0IIIII:='0';IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:=(OTHERS=>'0');IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=(OTHERS=>'0');IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:=(OTHERS=>'0');IIO1l1Ol1l11Il0000II00lI011I0IIIII:='0';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:=
'0';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='0';III00O11l11IlIOI1llIIIOII100lIIIII:='0';IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:='0';IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:='0';IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='0';IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:='1';III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:='1';IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:='0';
IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:='0';END IF;FOR II1011l1lI11IlIlI0l0l00100lO0IIIII IN 0 TO IO0IlO1lI10Il011101l101IIl0IOIIIII-1 LOOP IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII):=IIII00I101O111lII1O000IO1lOOIIIIII(IOO0I1l1IOO0II0O00I0IllOOI1OOIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII,II10l111IOllO0O1111Ill001lll1IIIII,C_OUTPUT_RATE,
IO0IlO1lI10Il011101l101IIl0IOIIIII))(IIOOO0OOIll110IlI1111I1001I01IIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII,II10l111IOllO0O1111Ill001lll1IIIII,C_OUTPUT_RATE,IO0IlO1lI10Il011101l101IIl0IOIIIII));END LOOP;FOR IO1OO10IOIO11O10IOOOllllI1Il0IIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IIl110lllO10l0llOI11l01I0I1OlIIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII
)(C_PUNC_INPUT_RATE-1 DOWNTO 1):=IOOll11IO1O1llOIl10010O1IIOOIIIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII)(C_PUNC_INPUT_RATE-2 DOWNTO 0);IIl110lllO10l0llOI11l01I0I1OlIIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII)(0):=II00l0IOI1lIlOlOOI0I011O1110OIIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII);END LOOP;IF(IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND
 III1I01Ill1l0lOIlO01lO0I1IlIIOIIII='1')THEN IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:='1';ELSE IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:='0';END IF;IF(RISING_EDGE(CLK)AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='0'AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1')THEN IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:=
III011IIIl1IO1l0O11000I0llI00IIIII;IF((IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND IOIIOO1001lI01IOOlOllIOOIO1O1IIIII='0')OR(IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII='1'))THEN IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:='1';ELSE IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:='0';END IF;IF(
IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND IOIIOO1001lI01IOOlOllIOOIO1O1IIIII='0')THEN IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:='1';END IF;IF(II1lI11lI1II1000lOllIOl01l0l0IIIII='1')THEN IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:=IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII;IIII00I101O111lII1O000IO1lOOIIIIII:=IOOll11IO1O1llOIl10010O1IIOOIIIIII;ELSE
 IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:=IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII;END IF;IF II1lI11lI1II1000lOllIOl01l0l0IIIII='1'THEN III11I01Ol11IOO00IOI1I11OOl10IIIII:=1;END IF;IF(C_HAS_RDY=1)THEN IIll1lO0l0lI0OII00l00OO11IlO1IIIII:=(II1lI11lI1II1000lOllIOl01l0l0IIIII AND
 NOT(IIll1lO0l0lI0OII00l00OO11IlO1IIIII))OR(NOT(IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII AND NOT(II1lI11lI1II1000lOllIOl01l0l0IIIII))AND IIll1lO0l0lI0OII00l00OO11IlO1IIIII);IF III11I01Ol11IOO00IOI1I11OOl10IIIII/=0 THEN IO111Il1I1O0lO1OlOI0l01I1O010IIIII:=IO111Il1I1O0lO1OlOI0l01I1O010IIIII+1;END
 IF;IF(IO111Il1I1O0lO1OlOI0l01I1O010IIIII=IO0IlO1lI10Il011101l101IIl0IOIIIII-1)THEN IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='1';ELSE IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';END IF;IF(II1lI11lI1II1000lOllIOl01l0l0IIIII='1')THEN
 IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';IO111Il1I1O0lO1OlOI0l01I1O010IIIII:=0;END IF;IF(IO111Il1I1O0lO1OlOI0l01I1O010IIIII=IO0IlO1lI10Il011101l101IIl0IOIIIII)THEN IO111Il1I1O0lO1OlOI0l01I1O010IIIII:=0;III11I01Ol11IOO00IOI1I11OOl10IIIII:=0;END IF;END IF;
IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII(IO0IlO1lI10Il011101l101IIl0IOIIIII-2 DOWNTO 0):=IIl1O01ll1111l0llIOO0OOl1ll0IOIIII(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO 1);IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII(IO0IlO1lI10Il011101l101IIl0IOIIIII-1):='0';IIO1l1Ol1l11Il0000II00lI011I0IIIII:=
IIl1O01ll1111l0llIOO0OOl1ll0IOIIII(0);III00O11l11IlIOI1llIIIOII100lIIIII:=IOO0llOIlIO0110l1lOO01I00l1OIIIIII OR IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII OR III00O11l11IlIOI1llIIIOII100lIIIII;IF(IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII='1'OR(IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII='1'))THEN IOOll11IO1O1llOIl10010O1IIOOIIIIII:=IIl110lllO10l0llOI11l01I0I1OlIIIII;END IF
;IF(IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND III1I01Ill1l0lOIlO01lO0I1IlIIOIIII='1')OR(IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII='1')THEN IF(C_PUNC_INPUT_RATE>2)THEN IOOI01II11O1I1IOII1II01O1001lIIIII:=IOOI01II11O1I1IOII1II01O1001lIIIII+1;END IF;IF(
IIOlIO1l10OOO1l1IlII1ll0100IOIIIII='1')THEN IF(C_PUNC_INPUT_RATE>2)THEN IOOI01II11O1I1IOII1II01O1001lIIIII:=0;END IF;END IF;IF(C_PUNC_INPUT_RATE>2)THEN IF(IOOI01II11O1I1IOII1II01O1001lIIIII=
C_PUNC_INPUT_RATE-1)THEN III011IIIl1IO1l0O11000I0llI00IIIII:='1';ELSE III011IIIl1IO1l0O11000I0llI00IIIII:='0';END IF;IF(IOOI01II11O1I1IOII1II01O1001lIIIII=C_PUNC_INPUT_RATE)THEN IOOI01II11O1I1IOII1II01O1001lIIIII:=0;END IF;END
 IF;IF(C_PUNC_INPUT_RATE=2)THEN III011IIIl1IO1l0O11000I0llI00IIIII:=(NOT IIOlIO1l10OOO1l1IlII1ll0100IOIIIII)AND(NOT III011IIIl1IO1l0O11000I0llI00IIIII);END IF;END IF;II1lI11lI1II1000lOllIOl01l0l0IIIII:=II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII;II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII
:=III011IIIl1IO1l0O11000I0llI00IIIII AND NOT IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII;IF C_HAS_RFD/=0 THEN IF(C_PUNC_OUTPUT_RATE-C_PUNC_INPUT_RATE=1)THEN III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:=NOT II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII;ELSIF
(C_PUNC_OUTPUT_RATE-C_PUNC_INPUT_RATE=2)THEN III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:=NOT(II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII OR II1lI11lI1II1000lOllIOl01l0l0IIIII);ELSE IF II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII='1'THEN III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:='0';ELSIF(
IO111Il1I1O0lO1OlOI0l01I1O010IIIII=C_PUNC_OUTPUT_RATE-C_PUNC_INPUT_RATE-2)THEN III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:='1';END IF;END IF;END IF;IF C_HAS_RFFD/=0 AND C_HAS_FD/=0 THEN
 IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:=(III011IIIl1IO1l0O11000I0llI00IIIII AND III1I01Ill1l0lOIlO01lO0I1IlIIOIIII)OR(NOT III00O11l11IlIOI1llIIIOII100lIIIII);END IF;II01l0llO10l10II111lIlOIllO0lIIIII:=II0l0001lI0I0IlllI1I100OO10IIIIIII;IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:=IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII;ELSIF(CLK'event
 AND CLK='1'AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1'AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1')THEN IF(C_HAS_RDY=1)THEN IO111Il1I1O0lO1OlOI0l01I1O010IIIII:=0;IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';END IF;FOR II1IOl1011OlI0O00l1O10OlllOI0IIIII IN 0 TO
 C_OUTPUT_RATE-1 LOOP IIII00I101O111lII1O000IO1lOOIIIIII(II1IOl1011OlI0O00l1O10OlllOI0IIIII):=(OTHERS=>'0');IOOll11IO1O1llOIl10010O1IIOOIIIIII(II1IOl1011OlI0O00l1O10OlllOI0IIIII):=(OTHERS=>'0');END LOOP;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:=(OTHERS=>'0');IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII(
IO0IlO1lI10Il011101l101IIl0IOIIIII-2 DOWNTO 0):=IIl1O01ll1111l0llIOO0OOl1ll0IOIIII(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO 1);IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII(IO0IlO1lI10Il011101l101IIl0IOIIIII-1):='0';IIO1l1Ol1l11Il0000II00lI011I0IIIII:=IIl1O01ll1111l0llIOO0OOl1ll0IOIIII(0);
IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='0';III00O11l11IlIOI1llIIIOII100lIIIII:='0';IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:='0';IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='0';IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:='1';II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:='0';II1lI11lI1II1000lOllIOl01l0l0IIIII:='0';IOOI01II11O1I1IOII1II01O1001lIIIII:=0;IO111Il1I1O0lO1OlOI0l01I1O010IIIII
:=0;III11I01Ol11IOO00IOI1I11OOl10IIIII:=0;III011IIIl1IO1l0O11000I0llI00IIIII:='0';IF C_HAS_RFFD/=0 AND C_HAS_FD/=0 THEN IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:=(III011IIIl1IO1l0O11000I0llI00IIIII AND IOl1I001lIl1Il1I11lI00l11O1OOIIIII)OR(NOT III00O11l11IlIOI1llIIIOII100lIIIII);
END IF;IF C_HAS_RFD/=0 THEN III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:='1';END IF;END IF;II0l0001lI0I0IlllI1I100OO10IIIIIII:=II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII AND NOT II1lI11lI1II1000lOllIOl01l0l0IIIII;IO01O100lOO0IOOI000OO1lIOO1l0IIIII<=IIO1l1Ol1l11Il0000II00lI011I0IIIII;IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII<=
IIll1lO0l0lI0OII00l00OO11IlO1IIIII;IO00OI0ll1l1l0llI1I000OOO0010IIIII<=IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII;IIIIOOlIIO11011I1IlOO10OOOO0OIIIII<=III1I01Ill1l0lOIlO01lO0I1IlIIOIIII;IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII<=II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII;II0I1I1l00l1O11OOIOIIllII10IlIIIII<=II1lI11lI1II1000lOllIOl01l0l0IIIII;IIOIlOO1lI01O10O1Ol0OOI10110OIIIII<=III011IIIl1IO1l0O11000I0llI00IIIII;
IO0II1lll1llOlO1lll1001O1IlOIOIIII<=IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII;IIlIIII1lOllO0IlO11I1O01110IOIIIII<=IIO00Il10lI0OOllOOO0lO11lOOlIOIIII;IOOO00lOlO0l0llI01lIlOOIIllIlIIIII<=III1I01Ill1l0lOIlO01lO0I1IlIIOIIII;II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII<=III00O11l11IlIOI1llIIIOII100lIIIII;IO0I10OO0llIIlII1I01OOI001IIIIIIII<=IO1l01O110OIl00l10lOOlI0lI0I0IIIII;
IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII<=IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII;IOOI10l11llO01llIIllOI1IO0l1OIIIII<=IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII;IOO1IIll11IlI110IOlllI1Il1IO1IIIII<=IIl1O01ll1111l0llIOO0OOl1ll0IOIIII;IOO000O0Ol1OlIOOI00l11I1l1I00IIIII<=IIII00I101O111lII1O000IO1lOOIIIIII(0);IIl11lIlOO0IIII0IOlI0l1000I1IIIIII<=
IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII;II1llIOlOlll00O010O1lI1IOI1I1IIIII<=IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(IOOI01II11O1I1IOII1II01O1001lIIIII,8);IO1I11OIllI1III1III11OlIIlIIOIIIII<=IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(IO111Il1I1O0lO1OlOI0l01I1O010IIIII,8);II110IlI0l101IO1IlI1O00llI00OIIIII<=
IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII;III0O000IO1IOIO10l0I00lOIII11IIIII<=IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII;IIO1IIOOO0OO1100OO11l0OOllIIIOIIII<=IIl110lllO10l0llOI11l01I0I1OlIIIII;IOO01O011lIIIlOl1O0lOIOOI110IOIIII<=IOOll11IO1O1llOIl10010O1IIOOIIIIII;END IF;END PROCESS;PUNCTURE_2O:PROCESS(CLK,
II00l0IOI1lIlOlOOI0I011O1110OIIIII,IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII)TYPE IO1OIOllI1llI01O00IIl0O111IIOOIIII IS ARRAY(0 TO C_OUTPUT_RATE-1)OF STD_LOGIC_VECTOR(IIOIOI0lO1lO100O11Il0OII11OlOIIIII-1 DOWNTO 0);TYPE
 IO01001lO000lI1lI0IO11lO0I1OlIIIII IS ARRAY(0 TO C_OUTPUT_RATE-1)OF STD_LOGIC_VECTOR(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO 0);VARIABLE IOOl11OIOl101I1I1I00lIlIlO00IIIIII:BOOLEAN:=TRUE;VARIABLE
 IIlOOO01III1O0O0IOII0I0lOlIlOIIIII,IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII,IIl010l00OlI0lO1OO11Il10lIOIOOIIII:IO1OIOllI1llI01O00IIl0O111IIOOIIII;VARIABLE IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII:INTEGER;VARIABLE IIl111Il0IIlOIO000I01l00l0111IIIII:INTEGER;VARIABLE II1111O0III10O0OOlOlOO1l1I1l0IIIII:STD_LOGIC;VARIABLE
 III00011101l1O1OOI0l0Il0l1l10IIIII:STD_LOGIC;VARIABLE IO0lll11llOIOOIOI1lOOIOl000I0IIIII:STD_LOGIC;VARIABLE IO00OO00lIlIO00llOIll10l0ll1OIIIII:STD_LOGIC;VARIABLE IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:STD_LOGIC;VARIABLE
 II1001l0I11O0IIOIl01I1ll0O0OlIIIII:STD_LOGIC;VARIABLE II1II1OO1ll10IlO0I10O0OI000IIOIIII:STD_LOGIC;VARIABLE IOOl01OO110II1I0lIlI001II11I0IIIII:STD_LOGIC;VARIABLE II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:STD_LOGIC;VARIABLE
 IIll0I0ll1ll1O0IOlO1O01llII00IIIII:STD_LOGIC;VARIABLE II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:STD_LOGIC;VARIABLE III0II00l1IIlIO100l00OlI1l1O0IIIII:STD_LOGIC;VARIABLE II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:STD_LOGIC_VECTOR(
C_OUTPUT_RATE-1 DOWNTO 0);VARIABLE IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII,III101l00lllOOOlIO0OO1lI1OO1OIIIII,II0l0l0II0Il010II1l000011O1lIIIIII,IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII:IO01001lO000lI1lI0IO11lO0I1OlIIIII;CONSTANT IOO0lOOOll1OI0OI0lI10IOOOII00IIIII:IOlI00I100IOOOl011O11IOI1l010IIIII:=(
C_PUNC_CODE0*(2**C_PUNC_INPUT_RATE)+C_PUNC_CODE0,C_PUNC_CODE1*(2**C_PUNC_INPUT_RATE)+C_PUNC_CODE1);VARIABLE II111O1llOOlI0lOOIIIl0OIlIlllIIIII,
IIO11lIl110IO0lO00IOOl0Il11I1IIIII,II1IO0OO0IOlO11110OOlO1O0101IOIIII:STD_LOGIC;VARIABLE II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:STD_LOGIC;BEGIN IF(C_PUNCTURED=1 AND C_DUAL_CHANNEL=1)THEN IF(IOOl11OIOl101I1I1I00lIlIlO00IIIIII)THEN IOOl11OIOl101I1I1I00lIlIlO00IIIIII:=
FALSE;FOR IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IIlOOO01III1O0O0IOII0I0lOlIlOIIIII(IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII):=(OTHERS=>'0');IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII(IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII):=(OTHERS=>'0');IIl010l00OlI0lO1OO11Il10lIOIOOIIII(IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII):=(OTHERS=>'0');END LOOP
;IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII:=0;IIl111Il0IIlOIO000I01l00l0111IIIII:=0;IO0lll11llOIOOIOI1lOOIOl000I0IIIII:='0';IO00OO00lIlIO00llOIll10l0ll1OIIIII:='0';III00011101l1O1OOI0l0Il0l1l10IIIII:='0';II1111O0III10O0OOlOlOO1l1I1l0IIIII:='0';II1II1OO1ll10IlO0I10O0OI000IIOIIII:='0';IOOl01OO110II1I0lIlI001II11I0IIIII:=
'0';II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:='0';IIll0I0ll1ll1O0IOlO1O01llII00IIIII:='1';II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:='0';III0II00l1IIlIO100l00OlI1l1O0IIIII:='0';IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:='0';II1001l0I11O0IIOIl01I1ll0O0OlIIIII:='0';FOR IO0lllOII000O01100OOI0II1II01IIIII IN 0 TO C_OUTPUT_RATE
-1 LOOP IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII(IO0lllOII000O01100OOI0II1II01IIIII):=(OTHERS=>'0');III101l00lllOOOlIO0OO1lI1OO1OIIIII(IO0lllOII000O01100OOI0II1II01IIIII):=(OTHERS=>'0');II0l0l0II0Il010II1l000011O1lIIIIII(IO0lllOII000O01100OOI0II1II01IIIII):=(OTHERS=>'0');II11OIIIO0I0OI0IIIIO1lOO011IlIIIII(IO0lllOII000O01100OOI0II1II01IIIII):='0';END LOOP;
II111O1llOOlI0lOOIIIl0OIlIlllIIIII:='0';II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:='0';IIO11lIl110IO0lO00IOOl0Il11I1IIIII:='0';END IF;FOR IO0IllIIO11IlI1010IIl0l000001IIIII IN 0 TO C_OUTPUT_RATE-1 LOOP FOR II1l0I0l10l0I1I1lO01l10I01lI1IIIII IN 0 TO IO0IlO1lI10Il011101l101IIl0IOIIIII-1 LOOP
 IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII(IO0IllIIO11IlI1010IIl0l000001IIIII)(II1l0I0l10l0I1I1lO01l10I01lI1IIIII):=IIl010l00OlI0lO1OO11Il10lIOIOOIIII(IIOl11l1l101llOl0l0l101I1O1llIIIII(IO0IllIIO11IlI1010IIl0l000001IIIII,II1l0I0l10l0I1I1lO01l10I01lI1IIIII,IOO0lOOOll1OI0OI0lI10IOOOII00IIIII,C_OUTPUT_RATE,IO0IlO1lI10Il011101l101IIl0IOIIIII))(IOIO00lO11l0IOO1l0I101I11l1OOIIIII(IO0IllIIO11IlI1010IIl0l000001IIIII,II1l0I0l10l0I1I1lO01l10I01lI1IIIII,
IOO0lOOOll1OI0OI0lI10IOOOII00IIIII,C_OUTPUT_RATE,IO0IlO1lI10Il011101l101IIl0IOIIIII));END LOOP;END LOOP;FOR IIO001lIl0II1lI10I1000O00Ol10IIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IIlOOO01III1O0O0IOII0I0lOlIlOIIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII)(IIOIOI0lO1lO100O11Il0OII11OlOIIIII-1
 DOWNTO 1):=IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII)(IIOIOI0lO1lO100O11Il0OII11OlOIIIII-2 DOWNTO 0);IIlOOO01III1O0O0IOII0I0lOlIlOIIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII)(0):=II00l0IOI1lIlOlOOI0I011O1110OIIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII);END LOOP;IF(IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1')THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:='1';ELSE
 IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:='0';END IF;IF(RISING_EDGE(CLK)AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='0'AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1')THEN III00011101l1O1OOI0l0Il0l1l10IIIII:=II1111O0III10O0OOlOlOO1l1I1l0IIIII;IF((IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND II1ll1Il1Il11O10OllIl0l1l1l0IOIIII='0')OR
(IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII='1'))THEN III0II00l1IIlIO100l00OlI1l1O0IIIII:='1';ELSE III0II00l1IIlIO100l00OlI1l1O0IIIII:='0';END IF;IF(IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'AND II1ll1Il1Il11O10OllIl0l1l1l0IOIIII='0')THEN II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:='1'
;END IF;IF(IO00OO00lIlIO00llOIll10l0ll1OIIIII='1')THEN IIl010l00OlI0lO1OO11Il10lIOIOOIIII:=IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII;END IF;IF(IO00OO00lIlIO00llOIll10l0ll1OIIIII='1')THEN II0l0l0II0Il010II1l000011O1lIIIIII:=IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII;ELSE II0l0l0II0Il010II1l000011O1lIIIIII:=
III101l00lllOOOlIO0OO1lI1OO1OIIIII;END IF;FOR IIOI1lO0I00III00II0IO0ll0111IOIIII IN 0 TO C_OUTPUT_RATE-1 LOOP II11OIIIO0I0OI0IIIIO1lOO011IlIIIII(IIOI1lO0I00III00II0IO0ll0111IOIIII):=II0l0l0II0Il010II1l000011O1lIIIIII(IIOI1lO0I00III00II0IO0ll0111IOIIII)(0);END LOOP;IF(C_HAS_RDY=1)THEN II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:=(
IO00OO00lIlIO00llOIll10l0ll1OIIIII OR II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII)AND NOT(II111O1llOOlI0lOOIIIl0OIlIlllIIIII AND NOT IO00OO00lIlIO00llOIll10l0ll1OIIIII);IIl111Il0IIlOIO000I01l00l0111IIIII:=IIl111Il0IIlOIO000I01l00l0111IIIII+1;IF(IIl111Il0IIlOIO000I01l00l0111IIIII=IO0IlO1lI10Il011101l101IIl0IOIIIII-1)THEN
 II111O1llOOlI0lOOIIIl0OIlIlllIIIII:='1';ELSE II111O1llOOlI0lOOIIIl0OIlIlllIIIII:='0';END IF;IF(IO00OO00lIlIO00llOIll10l0ll1OIIIII='1')THEN II111O1llOOlI0lOOIIIl0OIlIlllIIIII:='0';IIl111Il0IIlOIO000I01l00l0111IIIII:=0;END IF;IF(
IIl111Il0IIlOIO000I01l00l0111IIIII=IO0IlO1lI10Il011101l101IIl0IOIIIII)THEN IIl111Il0IIlOIO000I01l00l0111IIIII:=0;END IF;END IF;FOR III11OII1IlIl1001I1IO1111l0IlIIIII IN 0 TO C_OUTPUT_RATE-1 LOOP III101l00lllOOOlIO0OO1lI1OO1OIIIII(III11OII1IlIl1001I1IO1111l0IlIIIII)(IO0IlO1lI10Il011101l101IIl0IOIIIII-2
 DOWNTO 0):=II0l0l0II0Il010II1l000011O1lIIIIII(III11OII1IlIl1001I1IO1111l0IlIIIII)(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO 1);III101l00lllOOOlIO0OO1lI1OO1OIIIII(III11OII1IlIl1001I1IO1111l0IlIIIII)(IO0IlO1lI10Il011101l101IIl0IOIIIII-1):='0';END LOOP;IF(II1001l0I11O0IIOIl01I1ll0O0OlIIIII='1'OR(IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'
AND IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII='1'))THEN IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII:=IIlOOO01III1O0O0IOII0I0lOlIlOIIIII;END IF;IF(IOO0llOIlIO0110l1lOO01I00l1OIIIIII='1')THEN IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII:=IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII+1;IF(III0II00l1IIlIO100l00OlI1l1O0IIIII='1')THEN IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII
:=0;END IF;IF(IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII=IIOIOI0lO1lO100O11Il0OII11OlOIIIII-1)THEN II1111O0III10O0OOlOlOO1l1I1l0IIIII:='1';ELSE II1111O0III10O0OOlOlOO1l1I1l0IIIII:='0';END IF;IF(IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII=IIOIOI0lO1lO100O11Il0OII11OlOIIIII)THEN IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII
:=0;END IF;END IF;IOOl01OO110II1I0lIlI001II11I0IIIII:=IOO0llOIlIO0110l1lOO01I00l1OIIIIII OR IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII OR IOOl01OO110II1I0lIlI001II11I0IIIII;IO00OO00lIlIO00llOIll10l0ll1OIIIII:=IO0lll11llOIOOIOI1lOOIOl000I0IIIII;IO0lll11llOIOOIOI1lOOIOl000I0IIIII:=II1111O0III10O0OOlOlOO1l1I1l0IIIII AND NOT III00011101l1O1OOI0l0Il0l1l10IIIII;
II1001l0I11O0IIOIl01I1ll0O0OlIIIII:=IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;IF C_HAS_RFFD/=0 AND C_HAS_FD/=0 THEN IIll0I0ll1ll1O0IOlO1O01llII00IIIII:=IO0lll11llOIOOIOI1lOOIOl000I0IIIII OR(NOT IOOl01OO110II1I0lIlI001II11I0IIIII);END IF;IF C_HAS_RFFD/=0 AND
 C_HAS_FD=0 THEN IIll0I0ll1ll1O0IOlO1O01llII00IIIII:='1';END IF;ELSIF(CLK'event AND CLK='1'AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1')THEN IF IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'THEN II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:='0';IIO11lIl110IO0lO00IOOl0Il11I1IIIII:='0';
IO0lll11llOIOOIOI1lOOIOl000I0IIIII:='0';IO00OO00lIlIO00llOIll10l0ll1OIIIII:='0';II1111O0III10O0OOlOlOO1l1I1l0IIIII:='0';III00011101l1O1OOI0l0Il0l1l10IIIII:='0';IO00OO00lIlIO00llOIll10l0ll1OIIIII:='0';II1II1OO1ll10IlO0I10O0OI000IIOIIII:='0';IOOl01OO110II1I0lIlI001II11I0IIIII:='0';
II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:='0';IIll0I0ll1ll1O0IOlO1O01llII00IIIII:='1';IIl111Il0IIlOIO000I01l00l0111IIIII:=0;IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII:=0;II111O1llOOlI0lOOIIIl0OIlIlllIIIII:='0';II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:='0';III0II00l1IIlIO100l00OlI1l1O0IIIII:='0';IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:='0'
;II1001l0I11O0IIOIl01I1ll0O0OlIIIII:='0';FOR IIII11lI1lOl0OlOO0II11lI101lOIIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII(IIII11lI1lOl0OlOO0II11lI101lOIIIII):=(OTHERS=>'0');IIl010l00OlI0lO1OO11Il10lIOIOOIIII(IIII11lI1lOl0OlOO0II11lI101lOIIIII):=(OTHERS=>'0');END LOOP;FOR IOl0Ill1OOl0O1IO1l0010I0lO010IIIII IN 0 TO
 C_OUTPUT_RATE-1 LOOP II0l0l0II0Il010II1l000011O1lIIIIII(IOl0Ill1OOl0O1IO1l0010I0lO010IIIII):=(OTHERS=>'0');III101l00lllOOOlIO0OO1lI1OO1OIIIII(IOl0Ill1OOl0O1IO1l0010I0lO010IIIII)(IO0IlO1lI10Il011101l101IIl0IOIIIII-2 DOWNTO 0):=II0l0l0II0Il010II1l000011O1lIIIIII(IOl0Ill1OOl0O1IO1l0010I0lO010IIIII)(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO
 1);III101l00lllOOOlIO0OO1lI1OO1OIIIII(IOl0Ill1OOl0O1IO1l0010I0lO010IIIII)(IO0IlO1lI10Il011101l101IIl0IOIIIII-1):='0';II11OIIIO0I0OI0IIIIO1lOO011IlIIIII(IOl0Ill1OOl0O1IO1l0010I0lO010IIIII):='0';END LOOP;END IF;END IF;IOl1100I00OlIllOI1I0III1O1l01IIIII<=II11OIIIO0I0OI0IIIIO1lOO011IlIIIII;IOI0111Il0IllIIO0O0lO0I111010IIIII<=II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII;
IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII<=IIll0I0ll1ll1O0IOlO1O01llII00IIIII;END IF;END PROCESS;CONV_SYNC:PROCESS(CLK,IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII,IOl1I001lIl1Il1I11lI00l11O1OOIIIII,IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII)VARIABLE IO0IlOI1OIOO0l101l10IO00l0101IIIII:BOOLEAN:=TRUE;VARIABLE IIOO1OlIO01I00l0OO0I11OII1OlOIIIII,
IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII,IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII,IIl1O1IllII0I01IlO01l0lII0lIOOIIII:STD_LOGIC;VARIABLE IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII:STD_LOGIC;CONSTANT IIII00IOl0llO0O011llO1lOOOIIOIIIII:INTEGER:=1;VARIABLE IIlOIl110lOl10lO1OIllII10IOO1IIIII:INTEGER:=0;VARIABLE
 IO0O00IOlOOIOO11lI01l000IIIIOIIIII:INTEGER:=0;VARIABLE II10I1011llOIIlI00OI0IIIl0OIOIIIII:STD_LOGIC;VARIABLE IOI0O1l0101lI100OIOIlll001OO1IIIII:STD_LOGIC;VARIABLE IIlI1lIIIOI0l01l01OOII00I0O0lIIIII,IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII:STD_LOGIC;VARIABLE IIl000O0IO0llO0II1lI1010lOO0IOIIII,IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:
STD_LOGIC;VARIABLE IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:INTEGER:=0;BEGIN IF(IO0IlOI1OIOO0l101l10IO00l0101IIIII)THEN IO0IlOI1OIOO0l101l10IO00l0101IIIII:=FALSE;IIl1O1IllII0I01IlO01l0lII0lIOOIIII:='0';IIOO1OlIO01I00l0OO0I11OII1OlOIIIII:='0';IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII:='0';IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII:='0';
IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII:='0';IO0O00IOlOOIOO11lI01l000IIIIOIIIII:=0;IIlOIl110lOl10lO1OIllII10IOO1IIIII:=0;IIlI1lIIIOI0l01l01OOII00I0O0lIIIII:='0';IIl000O0IO0llO0II1lI1010lOO0IOIIII:='0';IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:='0';IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII:='0';IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:=0;IOI0O1l0101lI100OIOIlll001OO1IIIII:='0';IF(C_PUNCTURED=0)
THEN II10I1011llOIIlI00OI0IIIl0OIOIIIII:='0';END IF;END IF;IF(C_PUNCTURED=0)THEN IIO00Il10lI0OOllOOO0lO11lOOlIOIIII<='1';IOO0llOIlIO0110l1lOO01I00l1OIIIIII<=IOl1I001lIl1Il1I11lI00l11O1OOIIIII AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII;IIO0101IlI11I0IOlI01l1ll0O10OIIIII<='1';IF(C_HAS_RDY/=0)THEN IF(
RISING_EDGE(CLK)AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='0'AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1')THEN II10I1011llOIIlI00OI0IIIl0OIOIIIII:=IOI0O1l0101lI100OIOIlll001OO1IIIII;IOI0O1l0101lI100OIOIlll001OO1IIIII:=IOl1I001lIl1Il1I11lI00l11O1OOIIIII;ELSIF(RISING_EDGE(CLK)AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1'AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1')THEN
 II10I1011llOIIlI00OI0IIIl0OIOIIIII:='0';IOI0O1l0101lI100OIOIlll001OO1IIIII:='0';END IF;END IF;IOl00OIO0IOOllO1I1O101lIIl11OIIIII<=II10I1011llOIIlI00OI0IIIl0OIOIIIII;END IF;IF(C_PUNCTURED=1 AND C_DUAL_CHANNEL=0)THEN IF(RISING_EDGE(CLK)AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII=
'1')THEN IF(III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='0')THEN IIl1O1IllII0I01IlO01l0lII0lIOOIIII:=IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII;IF(IIlI1lIIIOI0l01l01OOII00I0O0lIIIII='1')THEN IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:=IOlIll0lIIOlIl1l1lI01OII11lOIIIIII+1;IF(IOlIll0lIIOlIl1l1lI01OII11lOIIIIII=C_PUNC_INPUT_RATE)THEN IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII
:='1';ELSE IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII:='0';END IF;IF(IOlIll0lIIOlIl1l1lI01OII11lOIIIIII=C_PUNC_INPUT_RATE+1)THEN IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:=0;END IF;IF(IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII='1')THEN IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII:='0';IOlIll0lIIOlIl1l1lI01OII11lOIIIIII
:=0;END IF;END IF;ELSE IIl1O1IllII0I01IlO01l0lII0lIOOIIII:='0';IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:=0;IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII:='0';END IF;END IF;IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII:=NOT(IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII AND NOT(IIl1O1IllII0I01IlO01l0lII0lIOOIIII));IIlI1lIIIOI0l01l01OOII00I0O0lIIIII:=IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII
 AND IOl1I001lIl1Il1I11lI00l11O1OOIIIII AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII;IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:=IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII AND IIlI1lIIIOI0l01l01OOII00I0O0lIIIII;IIOO1OlIO01I00l0OO0I11OII1OlOIIIII:=IIlI1lIIIOI0l01l01OOII00I0O0lIIIII AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII;IIl000O0IO0llO0II1lI1010lOO0IOIIII:=III0l0O0I11OOO1lI0OOIO0llOlIlIIIII OR IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII;IOIO0OOIOIOl0OIllO011O11O0OOIIIIII<=IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII;IOO0llOIlIO0110l1lOO01I00l1OIIIIII<=IIlI1lIIIOI0l01l01OOII00I0O0lIIIII;END IF
;IF(C_PUNCTURED=1 AND C_DUAL_CHANNEL=1)THEN IOO0llOIlIO0110l1lOO01I00l1OIIIIII<=IOl1I001lIl1Il1I11lI00l11O1OOIIIII;END IF;END PROCESS;NOT_PUNC:IF(C_PUNCTURED=0)GENERATE DATA_OUT_V<=
IOO01101I01OlOIO111IIl0OOIOI0IIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;DATA_OUT_S<='X';END GENERATE;PUNC:IF(C_PUNCTURED=1 AND C_DUAL_CHANNEL=0)GENERATE II00l0IOI1lIlOlOOI0I011O1110OIIIII<=
IOIO1OI0IlI1I1010lO000IO01Ol0IIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;DATA_OUT_S<=IO01O100lOO0IOOI000OO1lIOO1l0IIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;NPL:FOR II1OO01O01O10l0IIOIII101O1000IIIII IN 0 TO C_OUTPUT_RATE-1 GENERATE DATA_OUT_V(II1OO01O01O10l0IIOIII101O1000IIIII)<='X';
END GENERATE;END GENERATE;PUNC_DO:IF(C_PUNCTURED=1)AND(C_DUAL_CHANNEL=1)GENERATE II00l0IOI1lIlOlOOI0I011O1110OIIIII<=IOIO1OI0IlI1I1010lO000IO01Ol0IIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;
DATA_OUT_V<=IOl1100I00OlIllOI1I0III1O1l01IIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;DATA_OUT_S<='X';END GENERATE;RFD_O:IF(C_HAS_RFD=1)GENERATE PUNC_SERIAL_RFD:IF((
C_PUNCTURED=1)AND(C_DUAL_CHANNEL=0))GENERATE IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII<=IIIIOOlIIO11011I1IlOO10OOOO0OIIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;RFD<=IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII;END GENERATE;PUNC_DUAL_RFD:IF((C_PUNCTURED
=1)AND(C_DUAL_CHANNEL/=0))GENERATE IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII<=IIO00Il10lI0OOllOOO0lO11lOOlIOIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;RFD<=IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII;END GENERATE;NP_RFD:IF(C_PUNCTURED=0)GENERATE IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII
<=IIO00Il10lI0OOllOOO0lO11lOOlIOIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;RFD<=IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII;END GENERATE;END GENERATE;RFD_O0:IF(C_HAS_RFD=0)GENERATE IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII<='1';RFD<='X';END GENERATE;
RFFD_O:IF(C_HAS_RFFD/=0)GENERATE RFFD_NOTP:IF(C_PUNCTURED=0)GENERATE IO0lI0OlO11O10O1III000O01l0l0IIIII<=IIO0101IlI11I0IOlI01l1ll0O10OIIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;RFFD<=IO0lI0OlO11O10O1III000O01l0l0IIIII;END GENERATE;
RFFD_PUNC:IF(C_PUNCTURED/=0)GENERATE DP:IF C_DUAL_CHANNEL/=0 GENERATE IO0lI0OlO11O10O1III000O01l0l0IIIII<=IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;RFFD<=IO0lI0OlO11O10O1III000O01l0l0IIIII;END GENERATE
;SP:IF C_DUAL_CHANNEL=0 GENERATE IO0lI0OlO11O10O1III000O01l0l0IIIII<=IO00OI0ll1l1l0llI1I000OOO0010IIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;RFFD<=IO0lI0OlO11O10O1III000O01l0l0IIIII;END GENERATE;END GENERATE;END GENERATE;RFFD_O0:IF(
C_HAS_RFFD=0)GENERATE IO0lI0OlO11O10O1III000O01l0l0IIIII<='1';RFFD<='X';END GENERATE;RDY_O:IF(C_HAS_RDY/=0)GENERATE NP_RDY:IF(C_PUNCTURED=0)GENERATE RDY<=
IOl00OIO0IOOllO1I1O101lIIl11OIIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;END GENERATE;P_RDY:IF(C_PUNCTURED/=0 AND C_DUAL_CHANNEL=0)GENERATE RDY<=IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;END GENERATE;
DP_RDY:IF(C_PUNCTURED/=0 AND C_DUAL_CHANNEL/=0)GENERATE RDY<=IOI0111Il0IllIIO0O0lO0I111010IIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;END GENERATE;END GENERATE;RDY_O0:IF(C_HAS_RDY=0)
GENERATE NP_RDY:IF(C_PUNCTURED=0)GENERATE IOl00OIO0IOOllO1I1O101lIIl11OIIIII<='1';END GENERATE;RDY<='X';END GENERATE;IIO1O00llO01OII1I11lIIO001lI0IIIII<=IOO0llOIlIO0110l1lOO01I00l1OIIIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;
IOIl1lI1IO111IO0OII101O1I0l0IOIIII<=IOIO0OOIOIOl0OIllO011O11O0OOIIIIII AFTER IOI1O00I10101l0I1001llOOI0I0IOIIII;END;
